// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : car[ car.cpp ]						Auter : KENSUKE WATANABE
//												Data  : 2017/08/24
//
// -------- -------- -------- -------- -------- -------- -------- --------
#include <assert.h>
#include "car.h"
#include "manager.h"
#include "camera.h"
#include "sceneModel.h"
#include "sceneField.h"
#include "Wwise.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// 萔`
// -------- -------- -------- -------- -------- -------- -------- --------
static const char* MODELNAME_STANDARDCAR_BODY = "data/MODEL/car/Sbody.x";
static const char* MODELNAME_STANDARDCAR_TIRE = "data/MODEL/car/Stire.x";

static const D3DXVECTOR3 STANDARDCAR_RF = D3DXVECTOR3(0.33f, 0.38f, -0.67f);
static const D3DXVECTOR3 STANDARDCAR_RB = D3DXVECTOR3(0.33f, 0.38f, 0.52f);

static const float STANDARDCAR_BASEPOS_Y = 1.0f; 
static const float FRICTIONAL = 0.99f;
static const float MOVE_SPEED = 0.03f;					// vC[ړx
static const float MOVE_BACK_SPEED = 0.005f;			// 
static const float MOVE_ROT_SPEED = D3DX_PI * 0.001f;	// vC[񑬓x
static const float ROT_FRICTIONAL = 0.95f;

static const float ROT_LIMIT = D3DX_PI * 0.015f;		// vC[E̐Βl

// ======== ======== ======== ======== ======== ======== ======== ========
// ÓIoϐ
// -------- -------- -------- -------- -------- -------- -------- --------
std::unordered_map<std::string, CCar*> CCar::m_umapCarManager;

// ======== ======== ======== ======== ======== ======== ======== ========
// RXgN^
// -------- -------- -------- -------- -------- -------- -------- --------
CCar::CCar()
	: m_pBody(nullptr), m_pos(D3DXVECTOR3(0.f, 0.f, 0.f)), m_rot(D3DXVECTOR3(0.f, 0.f, 0.f)), m_move(D3DXVECTOR3(0.f, 0.f, 0.f)), m_turn(0.f), 
		m_moveTurn(0.f), m_frictional(FRICTIONAL), m_camPosAt(D3DXVECTOR3(0.f, 0.f, 0.f))
{
	for (int n = 0; n < 4; n++) { m_pTire[n] = nullptr; }	// ^C *4
}

// ======== ======== ======== ======== ======== ======== ======== ========
// fXgN^
// -------- -------- -------- -------- -------- -------- -------- --------
CCar::~CCar()
{

}

// ======== ======== ======== ======== ======== ======== ======== ========
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CCar::Update(void)
{
	m_move.y -= 0.1f;			// III

	m_moveTurn *= ROT_FRICTIONAL;

	// x
	D3DXVECTOR2 vecMove = D3DXVECTOR2(m_move.x, m_move.z);
	float direction = D3DXVec2Length(&vecMove);
	if (direction > 1.f) {
		D3DXVECTOR3 limit;
		D3DXVec3Normalize(&limit, &m_move);
		m_move.x = limit.x * 1.f;
		m_move.z = limit.z * 1.f;
	}
	
	// ̓^C̐ʂIɌɖ߂
	if (direction <= 0.001f) {
		m_turn = 0.f;
	}

	// Փ˔
	for (int n = 0; n < MAX_SCENE_PRIORITY; n++)
	{
		std::list<CScene*> *lisScene = CScene::GetScene(n);
		for (CScene* pScene : *lisScene)
		{
			if (pScene == nullptr)continue;
			// ^Cv̎擾
			CScene::OBJTYPE objType = pScene->GetObjType();

			// tB[h̏ꍇ
			if (objType == CScene::OBJTYPE::FIELD)
			{
				// _ELXg
				CSceneField *pField = ((CSceneField*)pScene);
				float fieldY = pField->GetHeight(m_pos, nullptr);
				if (m_pos.y < fieldY)
				{
					m_pos = D3DXVECTOR3(m_pos.x, fieldY , m_pos.z);
					m_move.y = 0.f;
				}
			}
		}
	}

	// ʂ̉Z
	 m_turn+= m_moveTurn;

	// ʌEl̔
	if (m_turn > ROT_LIMIT) {
		m_turn = ROT_LIMIT;
	}
	else if (m_turn < ROT_LIMIT * -1.f) {
		m_turn = ROT_LIMIT * -1.f;
	}

	// ړʂ̉Z
	m_pos += m_move;

	// WƉ]ʂ̓{fBɑ
	m_pBody->SetPos(m_pos);
	m_pBody->SetRot(m_rot);

	// ^C̉]
	m_pTire[0]->SetRot(D3DXVECTOR3(0.f, m_moveTurn * -10.f, 0.f));
	m_pTire[1]->SetRot(D3DXVECTOR3(0.f, m_moveTurn * -10.f, 0.f));

	// _ɂė~WXɎԂ̍WɊ񂹂
	if (m_camPosAt != m_pos)m_camPosAt += (m_pos - m_camPosAt) * 0.5f;

	// J̉]
	CManager::GetCamera()->AddCamRoate(m_turn * direction * -20.f);

	// wwisẽCXi[W̍XV
	CWwise *pWwise = CManager::GetWwise();
	pWwise->SetRot(D3DXVECTOR3(0.f, m_rot.y - D3DX_PI * 0.5f, 0.f));		// ]
	pWwise->SetPos(m_pos);					// W
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Oi
// -------- -------- -------- -------- -------- -------- -------- --------
void CCar::MoveForward()
{
	// ݂̈ړʂɍ킹Ďԑ̂񂳂
	m_turn *= 0.3f;
	float turning = 0.f;
	D3DXVECTOR2 vecMove = D3DXVECTOR2(m_move.x, m_move.z) * 0.00001f;
	float saveTurning = D3DXVec2Length(&vecMove);
	if (m_turn > 0.f) {
		turning = m_turn - saveTurning;
		if (turning <= 0.f)turning = 0.f;
	}
	else if (m_turn < 0.f) {
		turning = m_turn + saveTurning;
		if (turning >= 0.f)turning = 0.f;
	}
	m_rot.y += turning * -1.f;

	// J̐ݒ
	CCamera *pCamera = CManager::GetCamera();
	pCamera->SetLockAt(m_camPosAt);
	D3DXVECTOR3 comPos = pCamera->GetPos();			// JW

	m_move += D3DXVECTOR3(cosf(m_rot.y * -1.f - D3DX_PI * 0.5f) * MOVE_SPEED, 0.f, sinf(m_rot.y * -1.f - D3DX_PI * 0.5f) * MOVE_SPEED);
	m_camPosAt = m_pos + m_move * 0.1f;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// i
// -------- -------- -------- -------- -------- -------- -------- --------
void CCar::MoveBackward()
{
	// ݂̈ړʂɍ킹Ďԑ̂񂳂
	m_turn *= 0.3f;
	float turning = 0.f;
	D3DXVECTOR2 vecMove = D3DXVECTOR2(m_move.x, m_move.z) * 0.00001f;
	float saveTurning = D3DXVec2Length(&vecMove);
	if (m_turn > 0.f) {
		turning = m_turn - saveTurning;
		if (turning <= 0.f)turning = 0.f;
	}
	else if (m_turn < 0.f) {
		turning = m_turn + saveTurning;
		if (turning >= 0.f)turning = 0.f;
	}
	m_rot.y += turning * 1.f;

	// J̐ݒ
	CCamera *pCamera = CManager::GetCamera();
	pCamera->SetLockAt(m_camPosAt);
	D3DXVECTOR3 comPos = pCamera->GetPos();			// JW

	m_move += D3DXVECTOR3(cosf(m_rot.y * -1.f + D3DX_PI * 0.5f) * MOVE_SPEED * 0.5f, 0.f, sinf(m_rot.y * -1.f + D3DX_PI * 0.5f) * MOVE_BACK_SPEED);
	m_camPosAt = m_pos + m_move * 0.1f;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CCar::MoveFrictional()
{
	m_moveTurn *= 0.9f;
	m_move.x *= m_frictional;	// C
	m_move.z *= m_frictional;	// C
	D3DXVECTOR2 vecMove = D3DXVECTOR2(m_move.x, m_move.z);
	float length = D3DXVec2Length(&vecMove);
	if (length > 0.1f)
	{
		m_turn *= 0.7f;
		// ݂̈ړʂɍ킹Ďԑ̂񂳂
		float turning = 0.f;
		float saveTurning = length * 0.00001f;
		if (m_turn > 0.f) {
			turning = m_turn - saveTurning;
			if (turning <= 0.f)turning = 0.f;
		}
		else if (m_turn < 0.f) {
			turning = m_turn + saveTurning;
			if (turning >= 0.f)turning = 0.f;
		}
		m_rot.y += turning * -1.f;

		// J̐ݒ
		CCamera *pCamera = CManager::GetCamera();
		pCamera->SetLockAt(m_camPosAt);
		D3DXVECTOR3 comPos = pCamera->GetPos();			// JW
		m_camPosAt = m_pos + m_move * 0.5f;
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// EɃ^C
// -------- -------- -------- -------- -------- -------- -------- --------
void CCar::TurnRight()
{
	m_moveTurn += MOVE_ROT_SPEED;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Ƀ^C
// -------- -------- -------- -------- -------- -------- -------- --------
void CCar::TurnLeft()
{
	m_moveTurn -= MOVE_ROT_SPEED;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// S
// -------- -------- -------- -------- -------- -------- -------- --------
void CCar::ReleaseAll(void)
{
	for (auto car : m_umapCarManager)
	{
		if (car.second != nullptr)
		{
			// 
			delete car.second;
			car.second = nullptr;
		}
	}
	// Reiɂ
	m_umapCarManager.clear();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
CCar* CCar::Create(D3DXVECTOR3 pos, D3DXVECTOR3 rot, std::string onlyCarName)
{
	CCar* pCar = new CCar();
	pCar->m_pos = pos;
	pCar->m_rot = rot;

	// {fB
	pCar->m_pBody = CSceneModel::Create(D3DXVECTOR3(0.f, 0.3f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), MODELNAME_STANDARDCAR_BODY);
	pCar->m_pBody->SetBasePos(D3DXVECTOR3(0.f, 0.3f, 0.f));
	pCar->m_pBody->SetBaseRot(D3DXVECTOR3(0.f, 0.f, 0.f));
	pCar->m_pBody->SetObjType(CScene::OBJTYPE::PLAYER);
	pCar->m_pBody->SetParent(nullptr);

	// ^C
	// LF
	D3DXVECTOR3 tirePos = D3DXVECTOR3(-STANDARDCAR_RF.x, STANDARDCAR_RF.y, STANDARDCAR_RF.z);
	pCar->m_pTire[0] = CSceneModel::Create(tirePos, D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), MODELNAME_STANDARDCAR_TIRE);
	pCar->m_pTire[0]->SetParent(pCar->m_pBody);

	// RF
	tirePos = D3DXVECTOR3(STANDARDCAR_RF.x, STANDARDCAR_RF.y, STANDARDCAR_RF.z);
	pCar->m_pTire[1] = CSceneModel::Create(tirePos, D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), MODELNAME_STANDARDCAR_TIRE);
	pCar->m_pTire[1]->SetParent(pCar->m_pBody);

	// LB
	tirePos = D3DXVECTOR3(-STANDARDCAR_RB.x, STANDARDCAR_RB.y, STANDARDCAR_RB.z);
	pCar->m_pTire[2] = CSceneModel::Create(tirePos, D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), MODELNAME_STANDARDCAR_TIRE);
	pCar->m_pTire[2]->SetParent(pCar->m_pBody);

	// RB
	tirePos = D3DXVECTOR3(STANDARDCAR_RB.x, STANDARDCAR_RB.y, STANDARDCAR_RB.z);
	pCar->m_pTire[3] = CSceneModel::Create(tirePos, D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), MODELNAME_STANDARDCAR_TIRE);
	pCar->m_pTire[3]->SetParent(pCar->m_pBody);

	// Reiɂ߂
	m_umapCarManager[onlyCarName] = pCar;
	return pCar;
}